"""Memory One strategies. Note that there are Memory One strategies in other
files, including titfortat.py and zero_determinant.py"""

import warnings

from typing import Optional, Tuple

from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class WinStayLoseShift(Player):
    """
    Win-Stay Lose-Shift, also called Pavlov.

    Names:

    - Win Stay Lose Shift: [Nowak1993]_
    - WSLS: [Stewart2012]_
    - Pavlov: [Kraines1989]_
    """

    name = "Win-Stay Lose-Shift"
    classifier = {
        "memory_depth": 1,  # Memory-one Four-Vector
        "stochastic": False,
        "makes_use_of": set(),
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        if not self.history:
            return C
        # React to the opponent's last move
        last_round = (self.history[-1], opponent.history[-1])
        if last_round == (C, C) or last_round == (D, D):
            return C
        return D